
#ifndef _MAIN_H_
#define _MAIN_H_

#include "ht32.h"

#define		MDEBIO_ENABLE			1
#if	(MDEBIO_ENABLE == 1)

#define	MDBIO_P0_PORT				HT_GPIOB
#define	MDBIO_P0						GPIO_PIN_0
#define	MDBIO_P0_AFIO_PORT		GPIO_PB
#define	MDBIO_P0_AFIO_FUN			AFIO_FUN_GPIO

#define	MDBIO_P0_SET()				(MDBIO_P0_PORT->SRR = MDBIO_P0)
#define	MDBIO_P0_CLR()				(MDBIO_P0_PORT->RR = MDBIO_P0)
#define	MDBIO_P0_TOGGLE()			((MDBIO_P0_PORT->DOUTR & MDBIO_P0) ? MDBIO_P0_CLR():MDBIO_P0_SET())

#define	MDBIO_P1_PORT				HT_GPIOB
#define	MDBIO_P1						GPIO_PIN_1
#define	MDBIO_P1_AFIO_PORT		GPIO_PB
#define	MDBIO_P1_AFIO_FUN			AFIO_FUN_GPIO

#define	MDBIO_P1_SET()				(MDBIO_P1_PORT->SRR = MDBIO_P1)
#define	MDBIO_P1_CLR()				(MDBIO_P1_PORT->RR = MDBIO_P1)
#define	MDBIO_P1_TOGGLE()			((MDBIO_P1_PORT->DOUTR & MDBIO_P1) ? MDBIO_P1_CLR():MDBIO_P1_SET())
#endif

#define  Up_Key      0x08
#define  Down_Key    0x04
#define  Enter_Key   0x02
#define  Back_Key    0x01

#define  Key1      	 Back_Key
#define  Key2    		 Enter_Key
#define  Key3   		 Down_Key
#define  Key4    		 Up_Key

ErrStatus BC3603_Initial(void);
void MCU_gpio_Configuration(void);
void CKCU_Configuration(void);
void LCM_Display_Init(void);
void LCM_Display_Updata(void);

#endif   /*_MAIN_H_ */
